/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.events;

import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.LocationCheck;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class LootEvents {
    public static final ILootCondition.IBuilder IN_SWAMP = LocationCheck.func_215975_a((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_242666_a(Biomes.field_76780_h));
    public static final ILootCondition.IBuilder IN_SWAMP_HILLS = LocationCheck.func_215975_a((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_242666_a(Biomes.field_150599_m));
    public static final ILootCondition.IBuilder IN_RIVER = LocationCheck.func_215975_a((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_242666_a(Biomes.field_76781_i));
    public static final ILootCondition.IBuilder IN_WARM_OCEAN = LocationCheck.func_215975_a((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_242666_a(Biomes.field_203614_T));
    public static final ILootCondition.IBuilder IN_DEEP_WARM_OCEAN = LocationCheck.func_215975_a((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_242666_a(Biomes.field_203617_W));

    @SubscribeEvent
    public static void onInjectLoot(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        LootPool pool = event.getTable().getPool("main");
        if (name.equals((Object)LootTables.field_186390_ao)) {
            LootEvents.addEntry(pool, ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UAItems.PIKE.get())).func_216086_a(11).func_212840_b_((ILootCondition.IBuilder)IN_SWAMP.func_216297_a(IN_SWAMP_HILLS).func_216297_a(IN_RIVER))).func_216081_b());
            LootEvents.addEntry(pool, ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UAItems.LIONFISH.get())).func_216086_a(5).func_212840_b_((ILootCondition.IBuilder)IN_SWAMP.func_216297_a(IN_SWAMP_HILLS))).func_216081_b());
            LootEvents.addEntry(pool, ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UAItems.PERCH.get())).func_216086_a(18).func_212840_b_((ILootCondition.IBuilder)IN_WARM_OCEAN.func_216297_a(IN_DEEP_WARM_OCEAN))).func_216081_b());
        }
        if (name.equals((Object)LootTables.field_186388_am)) {
            LootEvents.addEntry(pool, ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UABlocks.DRIFTWOOD_LOG.get())).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)5))).func_216081_b());
            LootEvents.addEntry(pool, ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UABlocks.BLUE_PICKERELWEED.get())).func_216086_a(12).func_212840_b_((ILootCondition.IBuilder)IN_SWAMP.func_216297_a(IN_SWAMP_HILLS).func_216297_a(IN_RIVER))).func_216081_b());
            LootEvents.addEntry(pool, ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UABlocks.PURPLE_PICKERELWEED.get())).func_216086_a(12).func_212840_b_((ILootCondition.IBuilder)IN_SWAMP.func_216297_a(IN_SWAMP_HILLS).func_216297_a(IN_RIVER))).func_216081_b());
        }
    }

    @SubscribeEvent
    public static void addDrops(LivingDropsEvent event) {
        Random rand = event.getEntityLiving().func_70681_au();
        if (event.getEntity().func_200600_R() == EntityType.field_200800_n) {
            int spineAmount = event.getLootingLevel() > 0 ? (rand.nextInt(3) + 1) * event.getLootingLevel() : rand.nextInt(2) + 1;
            ItemEntity eyeDrop = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)UABlocks.ELDER_EYE.get()));
            ItemEntity spineDrop = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)UABlocks.ELDER_GUARDIAN_SPINE.get(), spineAmount));
            event.getDrops().add(eyeDrop);
            event.getDrops().add(spineDrop);
        } else if (event.getEntity().func_200600_R() == EntityType.field_200761_A) {
            int spineAmount = rand.nextInt(2) + rand.nextInt(event.getLootingLevel() + 1);
            ItemEntity drop = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)UABlocks.GUARDIAN_SPINE.get(), spineAmount));
            event.getDrops().add(drop);
        }
    }

    private static void addEntry(LootPool pool, LootEntry entry) {
        try {
            List lootEntries = (List)ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a").get(pool);
            if (lootEntries.stream().anyMatch(e -> e == entry)) {
                throw new RuntimeException("Attempted to add a duplicate entry to pool: " + entry);
            }
            lootEntries.add(entry);
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
    }
}

